<?php
/*--------------------------------------------------------------------
 OnGetSellingUnitPriceEventListener.php 2020-2-17
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\SellingUnit\Database\Price\ProductInformation\Listener;

use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\OnGetSellingUnitPriceEventInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\PriceFormatted;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\PricePlain;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\PriceStatus;

/**
 * Class OnGetSellingUnitPriceEventListener
 * @package Gambio\Shop\SellingUnit\Database\Price\ProductInformation\Listener
 */
class OnGetSellingUnitPriceEventListener
{
    /**
     * @param OnGetSellingUnitPriceEventInterface $event
     */
    public function __invoke(OnGetSellingUnitPriceEventInterface $event)
    {
        $product   = $event->product();
        $productId = $event->productId();
        $xtcPrice  = $event->xtcPrice();
    
        $formatPrice = true;
        $quantity    = $event->quantity()->value();
        $taxClassId  = $product->getTaxClassId();
        $price       = $product->getPrice();
        $asArray     = 1;
    
        [
            'formated' => $priceFormatted,
            'plain'    => $pricePlain
        ] = $xtcPrice->xtcGetPrice($productId->value(),
                                   $formatPrice,
                                   $quantity,
                                   $taxClassId,
                                   $price,
                                   $asArray);
    
        $event->builder()
            ->withPriceFormatted(new PriceFormatted($priceFormatted))
            ->withPricePlain(new PricePlain($pricePlain))
            ->withStatus($this->priceStatus($event->product()->priceStatus()));
    }
    /**
     * @param int $priceStatus
     * @return PriceStatus
     */
    protected function priceStatus(int $priceStatus) : PriceStatus
    {
        return new PriceStatus($priceStatus);

    }
}